/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.sound;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.Copyable;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Envelope
implements SWFEncodeable,
Copyable<Envelope> {
    private List<Level> levels;
    private transient int count;

    public Envelope(SWFDecoder coder) throws IOException {
        this.count = coder.readByte();
        this.levels = new ArrayList<Level>(this.count);
        for (int i = 0; i < this.count; ++i) {
            this.levels.add(new Level(coder));
        }
    }

    public Envelope(Envelope object) {
        this.levels = new ArrayList<Level>(object.levels);
    }

    public Envelope add(Level level) {
        if (level == null) {
            throw new IllegalArgumentException();
        }
        this.levels.add(level);
        return this;
    }

    public List<Level> getLevels() {
        return this.levels;
    }

    public void setLevels(List<Level> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.levels = list;
    }

    @Override
    public Envelope copy() {
        return new Envelope(this);
    }

    public String toString() {
        return this.levels.toString();
    }

    @Override
    public int prepareToEncode(Context context) {
        this.count = this.levels.size();
        return 1 + (this.count << 3);
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(this.count);
        for (Level level : this.levels) {
            level.encode(coder, context);
        }
    }

    public static final class Level
    implements SWFEncodeable {
        private static final String FORMAT = "Envelope: { mark=%d; left=%d; right=%d}";
        private final transient int mark;
        private final transient int left;
        private final transient int right;

        public Level(SWFDecoder coder) throws IOException {
            this.mark = coder.readInt();
            this.left = coder.readUnsignedShort();
            this.right = coder.readUnsignedShort();
        }

        public Level(int markValue, int leftValue, int rightValue) {
            this.mark = markValue;
            if (leftValue < 0 || leftValue > 65535) {
                throw new IllegalArgumentRangeException(0, 65535, leftValue);
            }
            this.left = leftValue;
            if (rightValue < 0 || rightValue > 65535) {
                throw new IllegalArgumentRangeException(0, 65535, rightValue);
            }
            this.right = rightValue;
        }

        public int getMark() {
            return this.mark;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public String toString() {
            return String.format(FORMAT, this.mark, this.left, this.right);
        }

        public boolean equals(Object object) {
            boolean result;
            if (object == null) {
                result = false;
            } else if (object == this) {
                result = true;
            } else if (object instanceof Level) {
                Level level = (Level)object;
                result = this.mark == level.mark && this.left == level.left && this.right == level.right;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            return (this.mark * 31 + this.left) * 31 + this.right;
        }

        @Override
        public int prepareToEncode(Context context) {
            return 8;
        }

        @Override
        public void encode(SWFEncoder coder, Context context) throws IOException {
            coder.writeInt(this.mark);
            coder.writeShort(this.left);
            coder.writeShort(this.right);
        }
    }
}

