/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.shape;

import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.linestyle.LineStyle;
import com.flagstone.transform.linestyle.LineStyle1;
import com.flagstone.transform.shape.Curve;
import com.flagstone.transform.shape.DefineShape2;
import com.flagstone.transform.shape.DefineShape3;
import com.flagstone.transform.shape.Line;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.shape.ShapeRecord;
import com.flagstone.transform.shape.ShapeStyle;
import java.util.ArrayList;
import java.util.List;

public final class Canvas {
    private static final double FLATTEN_LIMIT = 0.25;
    private static final int TWIPS_PER_PIXEL = 20;
    private static final int START = 0;
    private static final int CTRLA = 1;
    private static final int CTRLB = 2;
    private static final int ANCHOR = 3;
    private static final int MID = 2;
    private static final int CUBIC_POINTS = 4;
    private static final double CTRL_AVG = 2.0;
    private static final double ANCHOR_AVG = 3.0;
    private transient boolean pixels;
    private transient boolean pathInProgress = false;
    private final transient double[] cubicX = new double[4];
    private final transient double[] cubicY = new double[4];
    private transient int initialX;
    private transient int initialY;
    private transient int currentX;
    private transient int currentY;
    private transient int controlX;
    private transient int controlY;
    private transient int minX;
    private transient int minY;
    private transient int maxX;
    private transient int maxY;
    private transient int lineWidth;
    private final transient List<ShapeRecord> objects = new ArrayList<ShapeRecord>();
    private final transient List<LineStyle> lineStyles = new ArrayList<LineStyle>();
    private final transient List<FillStyle> fillStyles = new ArrayList<FillStyle>();

    public boolean isPixels() {
        return this.pixels;
    }

    public void setPixels(boolean arePixels) {
        this.pixels = arePixels;
    }

    public Bounds getBounds() {
        return new Bounds(this.minX, this.minY, this.maxX, this.maxY);
    }

    public List<LineStyle> getLineStyles() {
        ArrayList<LineStyle> list = new ArrayList<LineStyle>(this.lineStyles.size());
        for (LineStyle style : this.lineStyles) {
            list.add((LineStyle)style.copy());
        }
        return list;
    }

    public List<FillStyle> getFillStyles() {
        ArrayList<FillStyle> list = new ArrayList<FillStyle>(this.fillStyles.size());
        for (FillStyle style : this.fillStyles) {
            list.add((FillStyle)style.copy());
        }
        return list;
    }

    public Shape getShape() {
        ArrayList<ShapeRecord> list = new ArrayList<ShapeRecord>(this.objects.size());
        for (ShapeRecord record : this.objects) {
            list.add((ShapeRecord)record.copy());
        }
        return new Shape(list);
    }

    public void setLineStyle(LineStyle1 style) {
        int index;
        if (this.lineStyles.contains(style)) {
            index = this.lineStyles.indexOf(style);
        } else {
            index = this.lineStyles.size();
            this.lineStyles.add(style.copy());
        }
        this.lineWidth = style.getWidth();
        this.objects.add(new ShapeStyle().setLineStyle(index + 1));
    }

    public void setFillStyle(FillStyle style) {
        int index;
        if (this.fillStyles.contains(style)) {
            index = this.fillStyles.indexOf(style);
        } else {
            index = this.fillStyles.size();
            this.fillStyles.add((FillStyle)style.copy());
        }
        this.objects.add(new ShapeStyle().setFillStyle(index + 1));
    }

    public void setAltStyle(FillStyle style) {
        int index;
        if (this.fillStyles.contains(style)) {
            index = this.fillStyles.indexOf(style);
        } else {
            index = this.fillStyles.size();
            this.fillStyles.add((FillStyle)style.copy());
        }
        this.objects.add(new ShapeStyle().setAltFillStyle(index + 1));
    }

    public DefineShape2 defineShape(int identifier) {
        return new DefineShape2(identifier, this.getBounds(), this.getFillStyles(), this.getLineStyles(), this.getShape());
    }

    public DefineShape3 defineTransparentShape(int identifier) {
        return new DefineShape3(identifier, this.getBounds(), this.getFillStyles(), this.getLineStyles(), this.getShape());
    }

    public void clear() {
        this.pathInProgress = false;
        this.setInitial(0, 0);
        this.setCurrent(0, 0);
        this.setControl(0, 0);
        this.setBounds(0, 0, 0, 0);
        this.lineStyles.clear();
        this.fillStyles.clear();
        this.objects.clear();
        this.lineWidth = 0;
    }

    public void close() {
        int deltaX = this.initialX - this.currentX;
        int deltaY = this.initialY - this.currentY;
        if (deltaX != 0 || deltaY != 0) {
            this.objects.add(new Line(deltaX, deltaY));
        }
        this.setCurrent(this.initialX, this.initialY);
        this.pathInProgress = false;
    }

    public void move(int xCoord, int yCoord) {
        int pointX = this.pixels ? xCoord * 20 : xCoord;
        int pointY = this.pixels ? yCoord * 20 : yCoord;
        this.objects.add(new ShapeStyle().setMove(pointX, pointY));
        this.setControl((this.currentX + pointX) / 2, (this.currentY + pointY) / 2);
        this.setCurrent(pointX, pointY);
        this.setInitial(pointX, pointY);
    }

    public void moveForFont(int xCoord, int yCoord) {
        int pointX = this.pixels ? xCoord * 20 : xCoord;
        int pointY = this.pixels ? yCoord * 20 : yCoord;
        ShapeStyle style = new ShapeStyle().setMove(pointX, pointY);
        if (this.objects.isEmpty()) {
            style.setFillStyle(1);
        }
        this.objects.add(style);
        this.setControl((this.currentX + pointX) / 2, (this.currentY + pointY) / 2);
        this.setCurrent(pointX, pointY);
        this.setInitial(pointX, pointY);
    }

    public void rmove(int xCoord, int yCoord) {
        int pointX = this.pixels ? xCoord * 20 : xCoord;
        int pointY = this.pixels ? yCoord * 20 : yCoord;
        this.objects.add(new ShapeStyle().setMove(pointX + this.currentX, pointY + this.currentY));
        this.setControl(this.currentX + pointX / 2, this.currentY + pointY / 2);
        this.setCurrent(this.currentX + pointX, this.currentY + pointY);
    }

    public void line(int xCoord, int yCoord) {
        int pointX = (this.pixels ? xCoord * 20 : xCoord) - this.currentX;
        int pointY = (this.pixels ? yCoord * 20 : yCoord) - this.currentY;
        this.objects.add(new Line(pointX, pointY));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + pointX / 2, this.currentY + pointY / 2);
        this.setCurrent(this.currentX + pointX, this.currentY + pointY);
    }

    public void rline(int xCoord, int yCoord) {
        int pointX = this.pixels ? xCoord * 20 : xCoord;
        int pointY = this.pixels ? yCoord * 20 : yCoord;
        this.objects.add(new Line(pointX, pointY));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + pointX / 2, this.currentY + pointY / 2);
        this.setCurrent(this.currentX + pointX, this.currentY + pointY);
    }

    public void curve(int acontrolX, int acontrolY, int aanchorX, int aanchorY) {
        int ranchorY;
        int ranchorX;
        int rcontrolY;
        int rcontrolX;
        if (this.pixels) {
            rcontrolX = acontrolX * 20 - this.currentX;
            rcontrolY = acontrolY * 20 - this.currentY;
            ranchorX = aanchorX * 20 - this.currentX - rcontrolX;
            ranchorY = aanchorY * 20 - this.currentY - rcontrolY;
        } else {
            rcontrolX = acontrolX - this.currentX;
            rcontrolY = acontrolY - this.currentY;
            ranchorX = aanchorX - this.currentX - rcontrolX;
            ranchorY = aanchorY - this.currentY - rcontrolY;
        }
        this.objects.add(new Curve(rcontrolX, rcontrolY, ranchorX, ranchorY));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + rcontrolX, this.currentY + rcontrolY);
        this.setCurrent(this.currentX + rcontrolX + ranchorX, this.currentY + rcontrolY + ranchorY);
    }

    public void rcurve(int rcontrolX, int rcontrolY, int ranchorX, int ranchorY) {
        int py2;
        int px2;
        int py1;
        int px1;
        if (this.pixels) {
            px1 = rcontrolX * 20;
            py1 = rcontrolY * 20;
            px2 = ranchorX * 20;
            py2 = ranchorY * 20;
        } else {
            px1 = rcontrolX;
            py1 = rcontrolY;
            px2 = ranchorX;
            py2 = ranchorY;
        }
        this.objects.add(new Curve(px1, py1, px2, py2));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + px1, this.currentY + py1);
        this.setCurrent(this.currentX + px1 + px2, this.currentY + py1 + py2);
    }

    public void curve(int cax, int cay, int cbx, int cby, int anx, int any) {
        this.cubicX[0] = this.currentX;
        this.cubicY[0] = this.currentY;
        if (this.pixels) {
            this.cubicX[1] = cax * 20;
            this.cubicY[1] = cay * 20;
            this.cubicX[2] = cbx * 20;
            this.cubicY[2] = cby * 20;
            this.cubicX[3] = anx * 20;
            this.cubicY[3] = any * 20;
        } else {
            this.cubicX[1] = cax;
            this.cubicY[1] = cay;
            this.cubicX[2] = cbx;
            this.cubicY[2] = cby;
            this.cubicX[3] = anx;
            this.cubicY[3] = any;
        }
        this.flatten();
    }

    public void rcurve(int controlAX, int controlAY, int controlBX, int controlBY, int anchorX, int anchorY) {
        this.cubicX[0] = this.currentX;
        this.cubicY[0] = this.currentY;
        if (this.pixels) {
            this.cubicX[1] = this.currentX + controlAX * 20;
            this.cubicY[1] = this.currentY + controlAY * 20;
            this.cubicX[2] = this.currentX + controlBX * 20;
            this.cubicY[2] = this.currentY + controlBY * 20;
            this.cubicX[3] = this.currentX + anchorX * 20;
            this.cubicY[3] = this.currentY + anchorY * 20;
        } else {
            this.cubicX[1] = this.currentX + controlAX;
            this.cubicY[1] = this.currentY + controlAY;
            this.cubicX[2] = this.currentX + controlBX;
            this.cubicY[2] = this.currentY + controlBY;
            this.cubicX[3] = this.currentX + anchorX;
            this.cubicY[3] = this.currentY + anchorY;
        }
        this.flatten();
    }

    public void reflect(int xCoord, int yCoord) {
        int rcontrolX = this.currentX - this.controlX;
        int rcontrolY = this.currentY - this.controlY;
        int pointX = (this.pixels ? xCoord * 20 : xCoord) - this.currentX;
        int pointY = (this.pixels ? yCoord * 20 : yCoord) - this.currentY;
        this.objects.add(new Curve(rcontrolX, rcontrolY, pointX, pointY));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(rcontrolX + this.currentX, rcontrolY + this.currentY);
        this.setCurrent(pointX + this.currentX, pointY + this.currentY);
    }

    public void rreflect(int xCoord, int yCoord) {
        int rcontrolX = this.currentX - this.controlX;
        int rcontrolY = this.currentY - this.controlY;
        int pointX = this.pixels ? xCoord * 20 : xCoord;
        int pointY = this.pixels ? yCoord * 20 : yCoord;
        this.objects.add(new Curve(rcontrolX, rcontrolY, pointX, pointY));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(rcontrolX + this.currentX, rcontrolY + this.currentY);
        this.setCurrent(pointX + this.currentX, pointY + this.currentY);
    }

    public void reflect(int ctrlX, int ctrlY, int anchorX, int anchorY) {
        int pointY;
        int pointX;
        int bcontrolY;
        int bcontrolX;
        int acontrolX = this.currentX - this.controlX;
        int acontrolY = this.currentY - this.controlY;
        if (this.pixels) {
            bcontrolX = ctrlX * 20 - this.currentX;
            bcontrolY = ctrlY * 20 - this.currentY;
            pointX = anchorX * 20 - this.currentX;
            pointY = anchorY * 20 - this.currentY;
        } else {
            bcontrolX = ctrlX - this.currentX;
            bcontrolY = ctrlY - this.currentY;
            pointX = anchorX - this.currentX;
            pointY = anchorY - this.currentY;
        }
        this.rcurve(acontrolX, acontrolY, bcontrolX, bcontrolY, pointX, pointY);
    }

    public void rreflect(int ctrlX, int ctrlY, int anchorX, int anchorY) {
        int pointY;
        int pointX;
        int bcontrolY;
        int bcontrolX;
        int acontrolX = this.currentX - this.controlX;
        int acontrolY = this.currentY - this.controlY;
        if (this.pixels) {
            bcontrolX = ctrlX * 20;
            bcontrolY = ctrlY * 20;
            pointX = anchorX * 20;
            pointY = anchorY * 20;
        } else {
            bcontrolX = ctrlX;
            bcontrolY = ctrlY;
            pointX = anchorX;
            pointY = anchorY;
        }
        this.rcurve(acontrolX, acontrolY, bcontrolX, bcontrolY, pointX, pointY);
    }

    public void rpolygon(int[] points) {
        int length = points.length;
        if (length % 2 == 1) {
            --length;
        }
        this.rmove(points[0], points[1]);
        for (int i = 2; i < length; i += 2) {
            this.rline(points[i], points[i + 1]);
        }
        this.close();
    }

    public void polygon(int[] points) {
        int length = points.length;
        if (length % 2 == 1) {
            --length;
        }
        this.move(points[0], points[1]);
        for (int i = 2; i < length; i += 2) {
            this.line(points[i], points[i + 1]);
        }
        this.close();
    }

    private void setInitial(int xCoord, int yCoord) {
        this.initialX = xCoord;
        this.initialY = yCoord;
    }

    private void setCurrent(int xCoord, int yCoord) {
        this.currentX = xCoord;
        this.currentY = yCoord;
        if (xCoord - this.lineWidth / 2 < this.minX) {
            this.minX = xCoord - this.lineWidth / 2;
        }
        if (yCoord - this.lineWidth / 2 < this.minY) {
            this.minY = yCoord - this.lineWidth / 2;
        }
        if (xCoord + this.lineWidth / 2 > this.maxX) {
            this.maxX = xCoord + this.lineWidth / 2;
        }
        if (yCoord + this.lineWidth / 2 > this.maxY) {
            this.maxY = yCoord + this.lineWidth / 2;
        }
    }

    private void setControl(int xCoord, int yCoord) {
        this.controlX = xCoord;
        this.controlY = yCoord;
        if (xCoord - this.lineWidth / 2 < this.minX) {
            this.minX = xCoord - this.lineWidth / 2;
        }
        if (yCoord - this.lineWidth / 2 < this.minY) {
            this.minY = yCoord - this.lineWidth / 2;
        }
        if (xCoord + this.lineWidth / 2 > this.maxX) {
            this.maxX = xCoord + this.lineWidth / 2;
        }
        if (yCoord + this.lineWidth / 2 > this.maxY) {
            this.maxY = yCoord + this.lineWidth / 2;
        }
    }

    private void setBounds(int xmin, int ymin, int xmax, int ymax) {
        this.minX = xmin;
        this.minY = ymin;
        this.maxX = xmax;
        this.maxY = ymax;
    }

    private void flatten() {
        double[] quadX = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] quadY = new double[]{0.0, 0.0, 0.0, 0.0};
        while (true) {
            double pointAX = 2.0 * this.cubicX[0] + this.cubicX[3] - 3.0 * this.cubicX[1];
            pointAX *= pointAX;
            double pointBX = 2.0 * this.cubicX[3] + this.cubicX[0] - 3.0 * this.cubicX[2];
            if (pointAX < (pointBX *= pointBX)) {
                pointAX = pointBX;
            }
            double pointAY = 2.0 * this.cubicY[0] + this.cubicY[3] - 3.0 * this.cubicY[1];
            pointAY *= pointAY;
            double pointBY = 2.0 * this.cubicY[3] + this.cubicY[0] - 3.0 * this.cubicY[2];
            if (pointAY < (pointBY *= pointBY)) {
                pointAY = pointBY;
            }
            if (pointAX + pointAY < 0.25) break;
            quadX[3] = this.cubicX[3];
            double delta = (this.cubicX[1] + this.cubicX[2]) / 2.0;
            this.cubicX[1] = (this.cubicX[0] + this.cubicX[1]) / 2.0;
            quadX[2] = (this.cubicX[2] + this.cubicX[3]) / 2.0;
            this.cubicX[2] = (this.cubicX[1] + delta) / 2.0;
            quadX[1] = (delta + quadX[2]) / 2.0;
            this.cubicX[3] = (this.cubicX[2] + quadX[1]) / 2.0;
            quadX[0] = (this.cubicX[2] + quadX[1]) / 2.0;
            quadY[3] = this.cubicY[3];
            delta = (this.cubicY[1] + this.cubicY[2]) / 2.0;
            this.cubicY[1] = (this.cubicY[0] + this.cubicY[1]) / 2.0;
            quadY[2] = (this.cubicY[2] + this.cubicY[3]) / 2.0;
            this.cubicY[2] = (this.cubicY[1] + delta) / 2.0;
            quadY[1] = (delta + quadY[2]) / 2.0;
            this.cubicY[3] = (this.cubicY[2] + quadY[1]) / 2.0;
            quadY[0] = (this.cubicY[2] + quadY[1]) / 2.0;
            this.flatten();
            this.cubicX[0] = quadX[0];
            this.cubicY[0] = quadY[0];
            this.cubicX[1] = quadX[1];
            this.cubicY[1] = quadY[1];
            this.cubicX[2] = quadX[2];
            this.cubicY[2] = quadY[2];
            this.cubicX[3] = quadX[3];
            this.cubicY[3] = quadY[3];
        }
        this.objects.add(new Line((int)this.cubicX[3] - this.currentX, (int)this.cubicY[3] - this.currentY));
        this.setControl((int)this.cubicX[1], (int)this.cubicY[1]);
        this.setControl((int)this.cubicX[2], (int)this.cubicY[2]);
        this.setCurrent((int)this.cubicX[3], (int)this.cubicY[3]);
    }
}

